<?php
/**
 * Implementation of hook_drush_command().
 *
 */
function cosmo_repair_drush_command() {
  $items = array();
  $items['user-delete'] = array(
    'callback' => 'drush_cosmo_repair_user_delete',
    'examples' => array(
      'drush du',
    ),
    'aliases' => array('ud'),
    'bootstrap' => DRUSH_BOOTSTRAP_DRUPAL_FULL,
  );
  return $items;
}

function drush_cosmo_repair_user_delete(){
  global $user;
  $user = user_load(1);

  $i = 0;
  $query = db_query("SELECT uid FROM {users} WHERE uid > 3");
  while($res = db_fetch_array($query)) {
    user_delete(array(), $res['uid']);
    $i++;
    if($i%5000 == 0)
      drush_print('Users deleted : '.$i);
  }
}
